/**
* \file: AilAudioSink.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Audio sink endpoint implementation using AIL
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*          P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_AILAUDIOSINK_H
#define BDCL_AILAUDIOSINK_H

#include <string>
#include <memory>
#include <bdcl/BaiduCoreCallbackDealer.h>
#include <bdcl/AditAudioSink.h>

namespace adit { namespace bdcl {

class AilAudioSinkImpl;

/** @class  AilAudioSink
 *  @brief  AIL specific audio sink implementation.
 */
class AilAudioSink : public AditAudioSink
{
public:
    AilAudioSink(IAditAudioSinkCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer);
    virtual ~AilAudioSink();

    void setConfigItem(std::string inKey, std::string inValue);

    bool initialize();
    void teardown();

    bool playbackStart();
    bool playbackStop(bool inFlushBuffer);

private:
    std::unique_ptr<AilAudioSinkImpl> impl;
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_AILAUDIOSINK_H */
